<?php
/*
	Stempora web framework
	copyright (c) 2002-2018 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

	$Id: blog/site.php,v 1.0 3/16/2014  11:00:00 stempora Exp $
	description
*/

// dependencies

/**
* description
*
* @library	
* @author Emanuel Giurgea ( emanuel@stempora.com )
* @since 
*/
class CBlog extends CPlugin{
	
	var $tplvars; 

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $media = array(
		"path"	=> "./blog/",

		"tn"	=> array(
			"width"		=> "720",
			"height"	=> ""
		),

		"tn2"	=> array(
			"width"		=> "720",
			"height"	=> "406"
		)

	);
	

	function __constructor() {
		$this->name = "blog";

	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
	
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;

				case "landing":
					$_GET["sub"] = $sub = "topics";
				case "topics":
				case "labels":
				case "authors":
				case "pending":

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					$data->functions = array( 
							"onstore" => array(&$this , "StoreRecord"),
							"ondelete" => array(&$this , "DeleteRecord"),
					);					

					return $data->DoEvents();
				break;

				case "test":
					$this->OnCreate(array());
				break;
			}
		}
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRecord($record) {

		switch ($_GET["sub"]) {
			case "topics":
			case "pending":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_authors"],
					array(
						"author_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE item_author={$record[item_author]} ")
					),
					"author_id={$record[item_author]}"
				);


				if (count($tmp = explode("," , $record["item_labels"]))) {
					foreach ($tmp as $key => $val) {
						$this->db->QueryUpdate(
							$this->tables["plugin:blog_labels"],
							array(
								"label_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE find_in_set({$val} , item_labels)")
							),
							"label_id={$val}"
						);
					}					
				}

			break;
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteRecord($record) {

		switch ($_GET["sub"]) {

			case "topics":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_authors"],
					array(
						"author_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE item_author={$record[item_author]} ")
					),
					"author_id={$record[item_author]}"
				);
			break;

			case "authors":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_topics"],
					array(
						"item_status" => "0",
					),
					"item_author={$record[author_id]}"

				);
			break;
		}
		

	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		//create default widgets
		$wids = array (
			"categories"	=> $this->plugins["widgets"]->AddWidget(array(
				"type"			=> "cblogwidgetcategories",
				"type_name"		=> "Categories Menu",
				"title"			=> "Categories",
				"note"			=> "Auto-Generated",
				"settings"		=> array( "set_style"	=> "2" , "set_elements" => "1" , "set_show" => "0" , "set_empty" => "1"),
				"module"		=> $module_data["mod_id"],
			)),

			"topics"	=> $this->plugins["widgets"]->AddWidget(array(
				"type"			=> "cblogwidgettopiclist",
				"type_name"		=> "Topic List",
				"title"			=> "Latest Topics",
				"note"			=> "Auto-Generated",
				"settings"		=> array( "set_type"	=> "1" , "set_items" => "3" , "set_chars" => 200),
				"module"		=> $module_data["mod_id"],
			)),

			"search"	=> $this->plugins["widgets"]->AddWidget(array(
				"type"			=> "cblogwidgetsearch",
				"type_name"		=> "Search",
				"title"			=> "Search",
				"note"			=> "Auto-Generated",
				"module"		=> $module_data["mod_id"],
			)),

			"archive"	=> $this->plugins["widgets"]->AddWidget(array(
				"type"			=> "CBlogWidgetArchive",
				"type_name"		=> "Archive Menu",
				"title"			=> "Archive",
				"note"			=> "Auto-Generated",
				"module"		=> $module_data["mod_id"],
			)),
		);

		$widgets = array("__CONTENT__");

		if (is_object($this->plugins["comments"])) {
			$widgets[] = $this->plugins["comments"]->GetCommentsWidget();
		}
		

		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"],
				"block"			=> array(
					"col"	=> array(
						0 => array("size"	=> 9 , "widget"	=> $widgets),					
						1 => array("size"	=> 3 , "widget"	=> array( $wids["search"] , $wids["categories"] , $wids["archive"] )),
					)
				)				
			)
		);

/*
		$layout_details = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(
						0 => array("size"	=> 9 , "widget"	=> array( "__CONTENT__"  , $this->plugins["comments"]->GetCommentsWidget())),					
						0 => array("size"	=> 9 , "widget"	=> array( "__CONTENT__"  , $this->plugins["comments"]->GetCommentsWidget())),					
						1 => array("size"	=> 3 , "widget"	=> array( $wids["search"] , $wids["categories"] , $wids["archive"] )),
					)
				)				
			)
		);

*/
		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout"			=> $layout,
				"set_layout_archive"	=> $layout,
				"set_layout_search"		=> $layout,
				"set_layout_author"		=> $layout,
				"set_layout_topic"		=> $layout,
			)
		);

		//create default labels
		$id = $this->db->QueryInsert(
			$this->tables["plugin:blog_labels"],
			array(
				"module_id"			=> $module_data["mod_id"],
				"label_status"		=> "1",
				"label_all"			=> "0",
			)
		);

		$this->db->QueryUpdate(
			$this->tables["plugin:blog_labels"],
			array(
				"label_order"	=> $id
			),
			"label_id={$id}"
		);

		$this->db->QueryInsert(
			$this->tables["plugin:blog_labels_lang"],
			array(
				"label_id"			=> $id,
				"module_id"			=> $module_data["mod_id"],
				"lang_id"			=> $_GET["lang_id"],
				"label_title"		=> "Default Category",
				"label_url"			=> CFile::Name2Url("Default Category"),
			)
		);

		//create default author
		$aid = $this->db->QueryInsert(
			$this->tables["plugin:blog_authors"],
			array(
				"module_id"			=> $module_data["mod_id"],
				"author_name"		=> "Default Author",
				"label_url"			=> CFile::Name2Url("Default Author"),			
			)
		);

		$this->db->QueryInsert(
			$this->tables["plugin:blog_authors_lang"],
			array(
				"author_id"			=> $aid,
				"module_id"			=> $module_data["mod_id"],
				"lang_id"			=> $_GET["lang_id"],
			)
		);


		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));

		//execute any other standard operations
		parent::onCreate($module_data);		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:blog_labels" , 
			"plugin:blog_labels_lang",
			"plugin:blog_topics",
			"plugin:blog_topics_lang",
			"plugin:blog_authors",
			"plugin:blog_authors_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	
	
}

?>